#
# YodaDaemon()
# author  Maurizio Nagni
# version 1.0 - 21 September 2005
#
# This is the main class for the managements of the data into NTSOMZ station.
# It have to manage the start of several subProcess like:
# - RawReader
# - Yoda
# - Process the Root scripts
# - copy the data to MEPHI and start the gridFTP transfer from MEPHI to CNAF
#
#  To execute from the command line:
#
#	python YodaDaemon.py [ yoda[start|stop|restart] | rawReader[start|stop|restart] ] configFile.conf
#
#	where configFile have to be conform to the structure
#
#	[name]
#	parameter:		value


import sys, os, time, logging
from signal import SIGTERM
from ngn.utils.Daemon import Daemon
from ngn.pamela.monitor.TransferMonitor import TransferMonitor
from ngn.pamela.monitor.YodaMonitor import YodaMonitor
from ngn.pamela.monitor.RawReaderMonitor import RawReaderMonitor
from ConfigParser import *


process = ''
action = ''
confFile = ''
if len(sys.argv) > 1 and not sys.argv[1] == '':
    process  = sys.argv[1]
    if (process == 'yoda') or (process == 'rawreader') or (process == 'transfer'):
        if len(sys.argv) > 2:
            action = sys.argv[2]
            if not (('stop' == action) or ('start' == action) or ('restart' == action)  or ('status' == action)):
                print 'Wrong action to start! \n'
                print "usage: %s start|stop|restart|status %s" % ('yoda|rawreader|transfer', 'pathToConfigureFile')
                sys.exit(1)
	if len(sys.argv) > 3:
        	confFile = sys.argv[3]
		if not (os.access(confFile, os.F_OK)):
			print 'Cannot find configuration file. \n'
			sys.exit(1)
	if (len(sys.argv) == 3):
		print 'Cannot find configuration file. \n'
		sys.exit(1)
			
    else:
        print 'Wrong process name to execute!\n'
        print "usage: %s start|stop|restart|status %s" % ('yoda|rawreader', 'pathToConfigureFile')
        sys.exit(1)

    config = ConfigParser()
    config.read(confFile)
    try:
	yodaLog 		= config.get('YodaDaemon', 'yodaLog')
	pidfileYoda 		= config.get('YodaDaemon', 'pidfileYoda')
	rawReaderLog 		= config.get('YodaDaemon', 'rawReaderLog')
	pidfileRawReader	= config.get('YodaDaemon', 'pidfileRawReader')
       	transferLog 		= config.get('YodaDaemon', 'transferLog')
	pidfileTransfer		= config.get('YodaDaemon', 'pidfileTransfer')
    except NoSectionError, detail:
	print 'Section missing in configuration file: ', detail
	sys.exit(1)
    except NoOptionError, detail:
	print 'Wrong option in configuration file: ', detail
	sys.exit(1)

    if 'yoda' == process:
    	lFile = yodaLog
	pFile = pidfileYoda
    if 'rawreader' == process:
    	lFile = rawReaderLog
	pFile = pidfileRawReader
    if 'transfer' == process:
    	lFile = transferLog
	pFile = pidfileTransfer
	
    dae = Daemon(appName = process, logfile = lFile, pidfile = pFile)
    if 'start' != action:
	dae.execCmd(action)

    
    if 'start' == action:
        try:
            if 'yoda' == process:
                # Start the YodaMonitor
                processPid = os.fork() 
                if processPid == 0:
                    dae.execCmd(action)
                    yoda = YodaMonitor(logger = dae.getLogger(), configFile = confFile)
                    yoda.execute()

            if 'rawreader' == process:
                # Start the RawReaderMonitor
                processPid = os.fork() 
                if processPid == 0:
                    dae.execCmd(action)
                    raw = RawReaderMonitor(configFile = confFile, logger=dae.getLogger())
                    raw.execute()
                
            if 'transfer' == process:
                # Start the TransferMonitor
                processPid = os.fork() 
                if processPid == 0:
                    dae.execCmd(action)
                    raw = TransferMonitor(configFile = confFile, logger=dae.getLogger())
                    raw.execute()
                    
        except OSError, e: 
            sys.stderr.write("fork #1 failed: (%d) %s\n" % (e.errno, e.strerror))
            sys.exit(1)
else:
    print 'Wrong or missing arguments!'
    print "usage: %s start|stop|restart|status %s" % ('yoda|rawreader|transfer', 'pathToConfigureFile') 
    sys.exit(2)







